# This R file was generated to analyse the qPCR results from 09/12/2021 done by Valerie for comparison of tissue-specific LOTR1 transgene expression in Col-0 and lotr1-10 backgrounds with pCASP1:CASP1-GFP marker.

# Note: Independent transformation line B of pC1 construct was ommitted after consideration of the raw data. The main reason was the strong upregulation of the native LOTR1 gene compared to all other lines.

# Quick description
# CASP1::CASP1-GFP marker lines in Col-0 and lotr1-10 background were transformed with tissue specific expression constructs expressing sec-mScarlet-I-LOTR1cDNA (without signal peptide).
# Seedlings were sown on 1/2 MS agar plates and stratified for 2 days before germinated in 5th floor growth chamber for 5 days. Roots were harvested and immediately shock frozen in liquid N2.
# RNA was extracted and reverse transcribed into cDNA for expression analysis by qPCR.

setwd("G:/My Drive/PhD/Project #1_Characterisation of LOTR1/qPCR expression check")

# Load in data and format
# -------------------------------------------------
library(readr)
qPCR_results <- read_csv("G:/My Drive/PhD/Project #1_Characterisation of LOTR1/qPCR expression check/qPCR results Andreas - Raw for R.csv")


library(tidyr)
library(dplyr)


# Cleanup data by removing high CT values
qPCR_clean <- qPCR_results %>%
  filter(`LOTR1 CT value` < 33)



# NOTE: This removes 3rd triplicate from p35S Line A for wildtype gene (CT value of 37)
# ------------------------------------------------- 


# Calculate dCT values
# -------------------------------------------------  
qPCR_clean$dCT <- qPCR_clean$`LOTR1 CT value` - qPCR_clean$`clathrin CT value`
qPCR_clean$FC <- 2^-(qPCR_clean$dCT)


# Filter for WT gene specific probe results
qPCR_WT <- qPCR_clean %>%
  filter(Probe == "wildtype") %>%
  group_by(Transgene) #%>%
  #summarize(mean_transgene = mean(`LOTR1 CT value`), mean_clathrin = mean(`clathrin CT value`), mean_dCT = mean(dCT), mean_FC = mean(FC))

qPCR_WT_sum <- qPCR_WT %>%
  summarize(mean_transgene = mean(`LOTR1 CT value`), mean_clathrin = mean(`clathrin CT value`), mean_dCT = mean(dCT), mean_FC = mean(FC))


# *************************************************
# Filter for transgene gene specific probe results
qPCR_trans <- qPCR_clean %>%
  filter(Probe == "transgene") %>%
  group_by(Transgene) #%>%
  #summarize(mean_transgene = mean(`LOTR1 CT value`), mean_clathrin = mean(`clathrin CT value`), mean_dCT = mean(dCT), mean_FC = mean(FC))

qPCR_trans_Col <- qPCR_trans %>%
  filter(background == "Col-0") %>%
  summarize(mean_transgene = mean(`LOTR1 CT value`), mean_clathrin = mean(`clathrin CT value`), mean_dCT = mean(dCT), mean_FC = mean(FC))

qPCR_trans_mut <- qPCR_trans %>%
  filter(background == "lotr1-10") %>%
  summarize(mean_transgene = mean(`LOTR1 CT value`), mean_clathrin = mean(`clathrin CT value`), mean_dCT = mean(dCT), mean_FC = mean(FC))
# ------------------------------------------------- 

# **************************************************
# Graphical analysis
# **************************************************
# -------------------------------------------------
library(ggplot2)

# **************************************************
# Wild-type gene expression in Col-0 background lines transformed with LOTR1 transgenes

pdf("qPCR results tissue specific expression.pdf", useDingbats=FALSE, width = 6.5, height = 4.25)

# ***********************************
# with lotr1
ggplot(data = qPCR_WT, aes(x = as.factor(Transgene)))+
  geom_boxplot(aes(y=FC))+
  ylim(0,2)+
  theme_classic()+
  xlab("Promoter driving transgene expression")+
  ylab("Fold change of expression normalized to Clathrin")+
  ggtitle("Native gene expression")+
  annotate("text", x = 1, y= 1.52, label = c(round(qPCR_WT_sum[1,5], 2)))+
  annotate("text", x = 2, y= 1.32, label = c(round(qPCR_WT_sum[2,5], 2)))+
  annotate("text", x = 3, y= 1.8, label = c(round(qPCR_WT_sum[3,5], 2)))+
  annotate("text", x = 4, y= 1.4, label = c(round(qPCR_WT_sum[4,5], 2)))+
  annotate("text", x = 5, y= 1.3, label = c(round(qPCR_WT_sum[5,5], 2)))+
  annotate("text", x = 6, y= 1.15, label = c(round(qPCR_WT_sum[6,5], 2)))+
  annotate("text", x = 7, y= 1.16, label = c(round(qPCR_WT_sum[7,5], 2)))+
  annotate("text", x = 8, y= 1.34, label = c(round(qPCR_WT_sum[8,5], 2)))+
  annotate("text", x = 9, y= 1.25, label = c(round(qPCR_WT_sum[9,5], 2)))

# ***********************************
# without lotr1
qPCR_WT_wolotr1 <- qPCR_WT %>%
  filter(Transgene != "lotr1")

ggplot(data = qPCR_WT_wolotr1, aes(x = as.factor(Transgene)))+
  geom_boxplot(aes(y=FC), width = 0.5)+
  ylim(0,2)+
  theme_classic()+
  xlab("Promoter driving transgene expression")+
  ylab("Fold change of expression normalized to Clathrin")+
  ggtitle("Native gene expression")+
  
  annotate("text", x = 1, y= 1.45, label = "ab")+
  annotate("text", x = 2, y= 1.75, label = "a")+
  annotate("text", x = 3, y= 1.25, label = "ab")+
  annotate("text", x = 4, y= 1.15, label = "ab")+
  annotate("text", x = 5, y= 1.0, label = "b")+
  annotate("text", x = 6, y= 1.0, label = "ab")+
  annotate("text", x = 7, y= 1.2, label = "ab")+
  annotate("text", x = 8, y= 1.1, label = "ab")+
  
  annotate("text", x = 1.45, y= 1.27, label = c(round(qPCR_WT_sum[1,5], 2)))+
  annotate("text", x = 2.45, y= 1.36, label = c(round(qPCR_WT_sum[3,5], 2)))+
  annotate("text", x = 3.45, y= 1.1, label = c(round(qPCR_WT_sum[4,5], 2)))+
  annotate("text", x = 4.45, y= 0.99, label = c(round(qPCR_WT_sum[5,5], 2)))+
  annotate("text", x = 5.45, y= 0.85, label = c(round(qPCR_WT_sum[6,5], 2)))+
  annotate("text", x = 6.45, y= 0.86, label = c(round(qPCR_WT_sum[7,5], 2)))+
  annotate("text", x = 7.45, y= 1.04, label = c(round(qPCR_WT_sum[8,5], 2)))+
  annotate("text", x = 8.45, y= 0.95, label = c(round(qPCR_WT_sum[9,5], 2)))




# Standard TukeyHSD test
anova_results <- aov(data = qPCR_WT_wolotr1, FC~Transgene)
summary(anova_results)
TukeyHSD(
  anova_results, "Transgene", ordered = T, conf.level = .95
  )

# Tukey HSD test with integrated grouping
library(agricolae)
results <- HSD.test(anova_results, "Transgene", group=TRUE, alpha = 0.01)
results
  

# **************************************************
# CASP1::CASP1-GFP (Col-0) background

#boxplot(qPCR_WT$FC ~ as.factor(qPCR_WT$Transgene))

ggplot(data = qPCR_trans[qPCR_trans$background == "Col-0",], aes(x = as.factor(Transgene)))+
  geom_boxplot(aes(y=FC), width = 0.5)+
  theme_classic()+
  xlab("Promoter driving transgene expression")+
  ylab("Fold change of expression normalized to Clathrin")+
  ggtitle("Transgene expression in Col-0 background")+
  
  annotate("text", x = 1, y= 5, label = "b")+
  annotate("text", x = 2, y= 5, label = "b")+
  annotate("text", x = 3, y= 5, label = "b")+
  annotate("text", x = 4, y= 25, label = "b")+
  annotate("text", x = 5, y= 65, label = "a")+
  annotate("text", x = 6, y= 75, label = "a")+
  annotate("text", x = 7, y= 5, label = "b")+
  
  annotate("text", x = 1.45, y= 1.76, label = c(round(qPCR_trans_Col[1,5], 2)))+
  annotate("text", x = 2.45, y= 1.3, label = c(round(qPCR_trans_Col[2,5], 2)))+
  annotate("text", x = 3.45, y= 2.5, label = c(round(qPCR_trans_Col[3,5], 2)))+
  annotate("text", x = 4.45, y= 21.31, label = c(round(qPCR_trans_Col[4,5], 2)))+
  annotate("text", x = 5.45, y= 57.42, label = c(round(qPCR_trans_Col[5,5], 2)))+
  annotate("text", x = 6.45, y= 50.33, label = c(round(qPCR_trans_Col[6,5], 2)))+
  annotate("text", x = 7.45, y= 0.61, label = c(round(qPCR_trans_Col[7,5], 2)))


# Tukey HSD test with integrated grouping
anova_results <- aov(data = qPCR_trans[qPCR_trans$background == "Col-0",], FC~Transgene)
results <- HSD.test(anova_results, "Transgene", group=TRUE, alpha = 0.01)
results


# **************************************************
# lotr1-10 CASP1::CASP1-GFP background

ggplot(data = qPCR_trans[qPCR_trans$background == "lotr1-10",], aes(x = as.factor(Transgene)))+
  geom_boxplot(aes(y=FC), width=0.5)+
  theme_classic()+
  xlab("Promoter driving transgene expression")+
  ylab("Fold change of expression normalized to Clathrin")+
  ggtitle("Transgene expression in lotr1-10 background")+
  
  annotate("text", x = 1, y= 5, label = "d")+
  annotate("text", x = 2, y= 5, label = "d")+
  annotate("text", x = 3, y= 5, label = "d")+
  annotate("text", x = 4, y= 23, label = "b")+
  annotate("text", x = 5, y= 15, label = "c")+
  annotate("text", x = 6, y= 75, label = "a")+
  annotate("text", x = 7, y= 5, label = "d")+
  
  annotate("text", x = 1.45, y= 1.24, label = c(round(qPCR_trans_mut[1,5], 2)))+
  annotate("text", x = 2.45, y= 1.17, label = c(round(qPCR_trans_mut[2,5], 2)))+
  annotate("text", x = 3.45, y= 0.62, label = c(round(qPCR_trans_mut[3,5], 2)))+
  annotate("text", x = 4.45, y= 16.79, label = c(round(qPCR_trans_mut[4,5], 2)))+
  annotate("text", x = 5.45, y= 10.43, label = c(round(qPCR_trans_mut[5,5], 2)))+
  annotate("text", x = 6.45, y= 70.49, label = c(round(qPCR_trans_mut[6,5], 2)))+
  annotate("text", x = 7.45, y= 0.28, label = c(round(qPCR_trans_mut[7,5], 2)))

anova_results <- aov(data = qPCR_trans[qPCR_trans$background == "lotr1-10",], FC~Transgene)
results <- HSD.test(anova_results, "Transgene", group=TRUE, alpha = 0.01)
results

# ******************************************************************************
# Combined plot
qPCR_combined <- qPCR_trans %>%
  unite('Merged', c(Transgene,background), remove = FALSE)


ggplot(data = qPCR_trans, aes(x = as.factor(Transgene)))+
  geom_boxplot(aes(y=FC, fill = background), width=0.75)+
  theme_classic()+
  scale_fill_manual(values = c("white", "gray"))+
  xlab("Promoter driving transgene expression")+
  ylab("Fold change of expression normalized to Clathrin")+
  theme(legend.position = c(0.925,0.90))+
  
  annotate("text", x = 0.8, y= 5, label = "d")+
  annotate("text", x = 1.8, y= 5, label = "d")+
  annotate("text", x = 2.8, y= 5, label = "d")+
  annotate("text", x = 3.8, y= 27, label = "c")+
  annotate("text", x = 4.8, y= 65, label = "b")+
  annotate("text", x = 5.8, y= 75, label = "ab")+
  annotate("text", x = 6.8, y= 5, label = "d")+
  
  annotate("text", x = 1.2, y= 5, label = "d")+
  annotate("text", x = 2.2, y= 5, label = "d")+
  annotate("text", x = 3.2, y= 5, label = "d")+
  annotate("text", x = 4.2, y= 23, label = "cd")+
  annotate("text", x = 5.2, y= 15, label = "cd")+
  annotate("text", x = 6.2, y= 75, label = "a")+
  annotate("text", x = 7.2, y= 5, label = "d")

  
anova_results <- aov(data = qPCR_combined, FC~Merged)
results <- HSD.test(anova_results, trt = "Merged", group=TRUE, alpha = 0.01)
results

results <- HSD.test(anova_results, trt = "background", group=TRUE, alpha = 0.01)
results




dev.off()








# ------------------------------------------------- 